% generate the training set

fclose all; close all; clear all; clc
tic

%% file name for generated trainset
trainset = 'challenge1_trainset.csv';

%% QRNG
NS = 1.2e6; % number of samples (rows in the CSV file)
Quasi = sobolset(2,'Skip',1e2,'Leap',0); % dimension = 2
Quasi = scramble(Quasi,'MatousekAffineOwen');
data = nan(NS,3); % columns will be: x, y, f(x,y)

%% calculate the trainset data
fprintf('Generating trainset data...\n')
data(:,1:2) = Quasi(1:NS,:); % initial NS samples
data(:,3) = challenge1_function(data(:,1),data(:,2));
toc

%% save
fprintf('Writing data to %s...\n',trainset)
writematrix(data,trainset,'Delimiter',';');
toc
fprintf('Done.\n')
