%% European call and put option prices
fclose all; close all; clear all; clc

%% parameters
problem = 1;
switch problem
    case 1
        %% option parameters
        K = 95;     % strike price
        tau = 0.25; % time to maturity (= 3 months)
        S0 = 100;   % spot price
        r = 0.1;    % risk-free interest rate (= 10% per anum)
        sig = 0.5;  % volatility (= 50% per anum)
        q = 0;      % no dividends
    case 2
        %% option parameters
        K = 600;    % strike price
        tau = 0.25; % time to maturity (= 3 months)
        %% model parameters
        S0 = 585;   % spot price
        r = 0.05;   % risk-free interest rate (= 25% per anum)
        sig = 0.25; % volatility (= 25% per anum)
        q = 0.045;  % dividends (= 4.5% per anum)
end

%% expected results
% 1.
% call = 13.6953      % or $13.70
% put = 6.3497        % or $6.35
% 2.
% call = 22.6716      % or $22.67
% put = 36.7626       % or $36.76

%% my price
[myCall,myPut] = myblsprice(S0, K, r, tau, sig, q);

mydata = [myCall myPut];
colNames = {'call', 'put'};
myresults = table(mydata(:,1),mydata(:,2),'VariableNames',colNames,'rowNames',{'my price'});

%% bls price
[usebls,errmsg] = license('checkout','Financial_Toolbox');
% usebls = 0;
if usebls
    [blsCall,blsPut] = blsprice(S0, K, r, tau, sig, q);
    
    aeCall = abs(myCall-blsCall);
    aePut = abs(myPut-blsPut);
    
    data = [ blsCall blsPut ; aeCall aePut];
    results = table(data(:,1),data(:,2),'VariableNames',colNames,'rowNames',{'bls price','abs. error'});
    myresults = [myresults;results];
end

%% print the comparison
disp(myresults)
