%% European call and put option prices as functions of S and sigma
fclose all; close all; clear all; clc
figpos = @(i) [0+(i-1)*50 100 1200 900]; % default position for figure(i), see also get(0,'ScreenSize');
figprint = 0;

%% parameters
problem = 1;
switch problem
    case 1
        %% option parameters
        K = 95;     % strike price
        tau = 0.25; % time to maturity (= 3 months)
        r = 0.1;    % risk-free interest rate (= 10% per anum)
        q = 0;      % no dividends
    case 2
        %% option parameters
        K = 600;    % strike price
        tau = 0.25; % time to maturity (= 3 months)
        %% model parameters
        r = 0.05;   % risk-free interest rate (= 25% per anum)
        q = 0.045;  % dividends (= 4.5% per anum)
end
S = linspace(0,2*K,25);
sig = .05:.05:.95;

%% Black-Scholes price
% [call, put] = blsprice(S, K, r, tau, sig, q); % ERROR: Inputs must be scalars or conforming matrices.

% we need to create conforming matrices first:
[newS, newsig] = meshgrid(S, sig);
% gives the same result as:
% newS = S(ones(length(sig), 1), :);
% newsig = sig(ones(length(S), 1), :)';

% [call, put] = blsprice(newS, K, r, tau, newsig, q);
[call, put] = myblsprice(newS, K, r, tau, newsig, q);

%% Plot the results
fig = figure(1);
fig.OuterPosition = figpos(1);
subplot(1,2,1); surf(newS, newsig, call);
title('Call Option'); 
xlabel('Stock Price'); ylabel('Volatility'); zlabel('Option Price');
subplot(1,2,2); surf(newS, newsig, put);
title('Put Option'); 
xlabel('Stock Price'); ylabel('Volatility'); zlabel('Option Price');
if figprint, myprint(fig,sprintf('%s_%u.fig',mfilename,fig.Number),figprint), end
