fclose all; close all; clear all; clc
% format long
[bls,~] = license('checkout','Financial_Toolbox'); % necessary for blsprice, blsimpv
bls = 0;

example = 1;

%% input data:
switch example
    case 1
        disp('----------------------------------------------------------- Example 1 - two options:')
        K = [0.9 1];
        S0 = [1 1];
        tau = [0.5 1];
        r = [0.05 0.055];
        C = [0.1264 0.1330] % Market prices
    case 2
        disp('---------------------------------------------- Example 2 - one "problematic" option:')
        % problematic case
        % https://stackoverflow.com/questions/19761021/implied-volatility-in-matlab
        % blsimpv(1558,1440,0.0024,(1/12),116.4)
        S0 = 1558; K = 1440; r = 0.0024; tau = 1/12;
        C = 116.4 % Market price
end

%% calculating implied volatilities
for j=1:length(C)
    if bls, iVol1(j) = blsimpv(S0(j),K(j),r(j),tau(j),C(j)); end
    iVol2(j) = myblsimpv(S0(j),K(j),r(j),tau(j),C(j));
end
% in vector form (no for loop):
iVol2 = myblsimpv(S0,K,r,tau,C);

%% back-testing obtained implied volatilities
if bls, 
    [call1,~] = blsprice(S0, K, r, tau, iVol1)
    error1 = call1-C
end
[call2,~] = myblsprice(S0, K, r, tau, iVol2)
error2 = call2-C
