function [call,put] = myblsprice(S, K, r, tau, sig, q)
%MYBLSPRICE Black-Scholes call and put option pricing.
%   Compute European call and put option prices using a Black-Scholes formula.
%   This function does not require the Financial Toolbox license and works similarly to blsprice
%
%   [Call,Put] = myblsprice(S, K, r, tau, sig)
%   [Call,Put] = myblsprice(S, K, r, tau, sig, q)

%  Example:
%  [Call, Put] = myblsprice(100, 95, 0.1, 0.25, 0.5)
%  Call = 13.6953
%  Put = 6.3497

% Author: Jan Pospisil, 2015-2023.

%% input arguments:
if nargin < 5
    error('%s:InsufficientInputs',mfilename)
end

nodiv = 0;
if (nargin < 6) || isempty(q)
    q = zeros(size(S));
    nodiv = 1;
end

%% BS with continuous yield dividend
sqrtau = sqrt(tau);
% d1 = 1./(sig*sqrtau).*(log(S./K)+(r-q).*tau + 0.5*sig.^2.*tau); 
d1 = (log(S./K)+(r-q).*tau)./(sig.*sqrtau) + 0.5*sig.*sqrtau; % equivalent
d2 = d1-sig.*sqrtau;

if (nodiv)
    call =  S.*normcdf(d1) -K.*exp(-r.*tau).*normcdf(d2);
    put  = -S.*normcdf(-d1)+K.*exp(-r.*tau).*normcdf(-d2);
else
    F = S.*exp((r-q)*tau);
    
    call = exp(-r*tau).*( F.*normcdf(d1) -K.*normcdf(d2));
    put  = exp(-r*tau).*(-F.*normcdf(-d1)+K.*normcdf(-d2));
end

end % function
