import numpy as np
from scipy.optimize import least_squares
from myblsprice import *

def myblsimpv(S0, K, r, tau, C):
    # options for least_squares
    options = {'max_nfev': 10000, 'xtol': 1e-20, 'verbose': 0}

    # initial guess
    method = 0

    switcher = {
        1: lambda: np.sqrt(2 * np.pi / tau) * C / S0,
        2: lambda: np.sqrt(2 * np.pi / tau * np.log(1 / (1 - (C / S0) ** 2))),
        3: lambda: np.sqrt(2 * np.pi / tau) * (C - (S0 - K * np.exp(-r * tau)) / 2) / (S0 - K * np.exp(-r * tau) / 2),
        4: lambda: np.sqrt(2 * np.pi / tau) * (C - (S0 - K * np.exp(-r * tau)) / 2 +
                                                 np.sqrt((C - (S0 - K * np.exp(-r * tau)) / 2) ** 2 -
                                                         (S0 - K * np.exp(-r * tau)) ** 2 / np.pi)) / (S0 + K * np.exp(-r * tau) / 2),
        5: lambda: None,
        6: lambda: None,
        0: lambda: 0.4 * np.ones(np.size(C))
    }
    
    sig0 = switcher[method]()

    # lower and upper bounds
    LB = 0.001 * np.ones(np.size(C))
    UB = 2 * np.ones(np.size(C))

    # calculate implied volatilities using least_squares
    if C != 0:
        # for non-zero prices of calls we try to obtain implied vol.
        try:
            res = least_squares(lambda sig: myblsprice(S0, K, r, tau, sig) - C, sig0, bounds=(LB, UB), method='lm', options=options)
            ivol = res.x
        except:
            ivol = np.nan * np.ones(np.size(C))
    else:
        ivol = np.nan * np.ones(np.size(C))

    return ivol

K = [0.9, 1]
S0 = [1, 1]
tau = [0.5, 1]
r = [0.05, 0.055]
C = [0.1264, 0.1330]
ivol = myblsimpv(S0, K, r, tau, C)
print(ivol)
